local t = LoadFallbackB()

t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay")

-- difficulty display
if ShowStandardDecoration("DifficultyIcon") then
	if GAMESTATE:GetPlayMode() == 'PlayMode_Rave' then
		-- in rave mode, we always have two players.
	else
		-- otherwise, we only want the human players
		for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
			local diffIcon = LoadActor(THEME:GetPathG(Var "LoadingScreen", "DifficultyIcon"), pn)
			t[#t+1] = StandardDecorationFromTable("DifficultyIcon" .. ToEnumShortString(pn), diffIcon);
		end
	end
end

-- record displays
if ShowStandardDecoration("RecordDisplays") then
	for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
		local curStageStats = STATSMAN:GetCurStageStats()
		local pss = curStageStats:GetPlayerStageStats(pn)

		-- high score indices are indexed by 0; -1 means no record
		-- xxx: is this shown on failure?
		-- xxx: how is this handled on summary?

		-- see if the player got a machine record
		local machineHighIndex = pss:GetMachineHighScoreIndex()
		if machineHighIndex ~= -1 then
			-- load machine record message
			local machineRecord = LoadActor(THEME:GetPathG(Var "LoadingScreen", "MachineRecord"), pn)
			t[#t+1] = StandardDecorationFromTable("MachineRecord" .. ToEnumShortString(pn), machineRecord);
		end

		-- see if the player got a personal record
		local personalHighIndex = pss:GetPersonalHighScoreIndex()
		if personalHighIndex ~= -1 then
			-- load personal record message
			local personalRecord = LoadActor(THEME:GetPathG(Var "LoadingScreen", "PersonalRecord"), pn)
			t[#t+1] = StandardDecorationFromTable("PersonalRecord" .. ToEnumShortString(pn), personalRecord);
		end
	end
end

-- extra stage thing
if ShowStandardDecoration("TryExtraStage") then
	if GAMESTATE:HasEarnedExtraStage() then
		t[#t+1] = StandardDecorationFromFile("TryExtraStage","TryExtraStage")
	end
end

return t